MFD_RTR_IP=${MFD_RTR_IP:-10.255.255.254}

source /lib/functions/sysconfig.sh

syslog_iface() {
  if [ -z "${SYSLOGSRV_IF:-}" ]; then
    if sysconfig_enabled netdev_config; then
      SYSLOGSRV_IF=$(sysconfig_metadata netdev_config interface)
    fi

    if [ -z "${SYSLOGSRV_IF:-}" ]; then
      SYSLOGSRV_IF="eth0"
    fi
  fi

  printf "%s\n" "$SYSLOGSRV_IF"
}

syslog_mac() {
  local iface=${1:-$(syslog_iface)}
  local mac=$(cat "/sys/class/net/${iface}/address" 2>/dev/null)

  if [ -z "$mac" ] && ! mac=$(cat /etc/NOS/MAC); then
    return 1
  fi

  printf '%s\n' "$mac"
}

calc_static_ip() {
  syslog_mac "$@" | awk '{
    split($1, a, ":");
    printf("10.%d.%d.%d\n", "0x"a[4], "0x"a[5], "0x"a[6]);
  }'
}
