#!/bin/sh
# Don't force-check ext{2,3,4} partitions

echo "SETUP: Disabling periodic filesystem repair mechanism."

set -e

for FILESYSTEM in ext2 ext3 ext4; do
   for LINE in $(mount | grep ${FILESYSTEM} | sed 's/ /\^/g'); do
      FSDEVICE=$(echo ${LINE} | awk -F '^' '{print $1}')
      echo "Device: ${FSDEVICE}"
      /sbin/tune2fs -c -1 -i 0 ${FSDEVICE}
   done
done

