#!/bin/sh
# Environment variables for the Qt package.
#
# It's best to use the generic directory to avoid
# compiling in a version-containing path:
if [ -d /usr/lib/qt ]; then
  QTDIR=/usr/lib/qt
else
  # Find the newest Qt directory and set $QTDIR to that:
  for qtd in /usr/lib/qt-* ; do
    if [ -d $qtd ]; then
      QTDIR=$qtd
    fi
  done
fi
if [ ! "$CPLUS_INCLUDE_PATH" = "" ]; then
  CPLUS_INCLUDE_PATH=$QTDIR/include:$CPLUS_INCLUDE_PATH
else
  CPLUS_INCLUDE_PATH=$QTDIR/include
fi
MANPATH="$MANPATH:$QTDIR/doc/man"
PATH="$PATH:$QTDIR/bin"
export QTDIR
export CPLUS_INCLUDE_PATH
export MANPATH

# HFP-1714: Font installation scripts grep for SYMLINK_FONTS, as NOS does not 
#           recursively search for the fonts dir. As this is just grep -q, define
#           in comments.
# SYMLINK_FONTS
