#!/bin/sh

# POST upload format:
# -----------------------------29995809218093749221856446032^M
# Content-Disposition: form-data; name="file1"; filename="..."^M
# Content-Type: application/octet-stream^M
# ^M    <--------- headers end with empty line
# file contents
# file contents
# file contents
# ^M    <--------- extra empty line
# -----------------------------29995809218093749221856446032--^M

# Beware: bashism $'\r' is used to handle ^M

file=/tmp/$$-$RANDOM

# CGI output must start with at least empty line (or headers)
printf '\r\n'
  cat <<EOF
<html>
<head>
<title>USR Upload</title>
<link rel="stylesheet" href="/styles/lowrance.css" /></head>

<body>
<div id="container">
<header id="site-header">
    <a href="/index.html"><img src="/images/lowrance.gif" alt="Lowrance" /></a></header>
<br clear="all">
<section class="module"><h1>Upload USR File</h1>
EOF

IFS=$'\r'
read -r delim_line

IFS=''
delim_line="${delim_line}--"$'\r'

read -r line
filename=$(echo $line | sed 's/^.*filename=//' | sed 's/\"//g' | sed 's/.$//')
fileext=${filename##*.}

while read -r line; do
    test "$line" = '' && break
    test "$line" = $'\r' && break
done

# Note: This will result in junk at end of line (see format above)
cat > $file

# Get the line count
LINES=$(wc -l $file | cut -d ' ' -f 1)

# Remove the last line
head -$((LINES - 1)) $file >$file.1

# Copy eveything but the last line to a temp file
head -$((LINES - 2)) $file.1 >$file.2

# Copy the new last line but remove trailing \r\n
tail -1 $file.1 > $file.3
tail -c 2 $file.3 > $file.5
CRLF=$(hexdump -ve '/1 "%.2x"' $file.5)
# Check if the last two bytes are \r\n
if [ "$CRLF" = "0d0a" ];then
   BYTES=$(wc -c $file.3 | cut -d ' ' -f 1)
   truncate -s $((BYTES-2)) $file.3
fi

rm $file.5
cat $file.2 $file.3 > $file.4
cp $file.4 $file

if [ "$fileext" = "usr" ]; then

   filepath="/home/nos/NOS/userdata/transfer/$filename"
   filepathtmp="/home/nos/NOS/userdata/transfer/tmp.usr"

   # first move to destination directory but using a tmp name (will be ignored by NOSApp)
   mv $file $filepathtmp

   # finally just rename to avoid a problem with the QFileSystemWatcher
   mv $filepathtmp $filepath
   chown nos:users $filepath

   cat <<EOF
<h2>Upload Successful</h2>
<p><a href=/index.html>home</a></p>
EOF

else

   rm $file

   cat <<EOF
<h2>Upload Unsuccessful</h2>
<p><b>File must have the extension <i>.usr</i></b></p>
<p><a href=/index.html>home</a></p>
EOF

fi

cat <<EOF
</section>
</div>
</body>
</html>
EOF


exit 0
