#!/bin/sh

SESSIONID=$(echo "$QUERY_STRING" | sed -n 's/^.*SessionId=\([^&]*\).*$/\1/p')
PROBLEMCODE1=$(echo "$QUERY_STRING" | sed -n 's/^.*ProblemCode1=\([^&]*\).*$/\1/p')
PROBLEMCODE2=$(echo "$QUERY_STRING" | sed -n 's/^.*ProblemCode2=\([^&]*\).*$/\1/p')
PROBLEMCODE3=$(echo "$QUERY_STRING" | sed -n 's/^.*ProblemCode3=\([^&]*\).*$/\1/p')
PROBLEMCOMMENT=$(echo "$QUERY_STRING" | sed -n 's/^.*ProblemComment=\([^&]*\).*$/\1/p' | sed "s/%20/ /g")
SCREENSHOTLIST1=$(echo "$QUERY_STRING" | sed -n 's/^.*ScreenshotList1=\([^&]*\).*$/\1/p' | sed "s/%20/ /g")
SCREENSHOTLIST2=$(echo "$QUERY_STRING" | sed -n 's/^.*ScreenshotList2=\([^&]*\).*$/\1/p' | sed "s/%20/ /g")
SCREENSHOTLIST3=$(echo "$QUERY_STRING" | sed -n 's/^.*ScreenshotList3=\([^&]*\).*$/\1/p' | sed "s/%20/ /g")
LOGFILESLIST1=$(echo "$QUERY_STRING" | sed -n 's/^.*LogFilesList1=\([^&]*\).*$/\1/p' | sed "s/%20/ /g")
LOGFILESLIST2=$(echo "$QUERY_STRING" | sed -n 's/^.*LogFilesList2=\([^&]*\).*$/\1/p' | sed "s/%20/ /g")
LOGFILESLIST3=$(echo "$QUERY_STRING" | sed -n 's/^.*LogFilesList3=\([^&]*\).*$/\1/p' | sed "s/%20/ /g")
EMAIL=$(echo "$QUERY_STRING" | sed -n 's/^.*Email=\([^&]*\).*$/\1/p' | sed "s/%20/ /g")
HOMECOUNTRY=$(echo "$QUERY_STRING" | sed -n 's/^.*HomeCountry=\([^&]*\).*$/\1/p' | sed "s/%20/ /g")
PHONE=$(echo "$QUERY_STRING" | sed -n 's/^.*Phone=\([^&]*\).*$/\1/p' | sed "s/%20/ /g")
INCIDENTNUMBER=$(echo "$QUERY_STRING" | sed -n 's/^.*IncidentNumber=\([^&]*\).*$/\1/p' | sed "s/%20/ /g")
MINIMISE=$(echo "$QUERY_STRING" | sed -n 's/^.*Minimise=\([^&]*\).*$/\1/p')

logger SESSIONID = ${SESSIONID}
logger PROBLEMCODE1 = ${PROBLEMCODE1}
logger PROBLEMCODE2 = ${PROBLEMCODE2}
logger PROBLEMCODE3 = ${PROBLEMCODE3}
logger PROBLEMCOMMENT = ${PROBLEMCOMMENT}
logger SCREENSHOTLIST1 = ${SCREENSHOTLIST1}
logger SCREENSHOTLIST2 = ${SCREENSHOTLIST2}
logger SCREENSHOTLIST3 = ${SCREENSHOTLIST3}
logger LOGFILESLIST1 = ${LOGFILESLIST1}
logger LOGFILESLIST2 = ${LOGFILESLIST2}
logger LOGFILESLIST3 = ${LOGFILESLIST3}
logger EMAIL = ${EMAIL}
logger HOMECOUNTRY = ${HOMECOUNTRY}
logger PHONE = ${PHONE}
logger INCIDENTNUMBER = ${INCIDENTNUMBER}
logger MINIMISE = ${MINIMISE}

fileSignal="/home/nos/NOS/userdata/transfer/reqReport.rq"
fileDownload="/home/nos/NOS/userdata/transfer/reqReport.nif_rq"

# settings signal file
JSON=""
if [ ! -z "$SESSIONID" ]; then
  JSON=${JSON}$(printf '"SessionId":"%s"' "$SESSIONID")
fi
if [ ! -z "$PROBLEMCODE1" ] || [ ! -z "$PROBLEMCODE2" ] || [ ! -z "$PROBLEMCODE3" ]; then
  PROBLEMCODE=$(printf '"%s"' "$PROBLEMCODE1")
  if [ ! -z "$PROBLEMCODE2" ]; then
    if [ ! -z "$PROBLEMCODE" ]; then
      PROBLEMCODE=${PROBLEMCODE}","
    fi
    PROBLEMCODE=${PROBLEMCODE}$(printf '"%s"' "$PROBLEMCODE2")
  fi
  if [ ! -z "$PROBLEMCODE3" ]; then
    if [ ! -z "$PROBLEMCODE" ]; then
      PROBLEMCODE=${PROBLEMCODE}","
    fi
    PROBLEMCODE=${PROBLEMCODE}$(printf '"%s"' "$PROBLEMCODE3")
  fi
  if [ ! -z "$JSON" ]; then
    JSON=${JSON}","
  fi
  JSON=${JSON}$(printf '"ProblemCodes":[%s]' "$PROBLEMCODE")
fi
if [ ! -z "$PROBLEMCOMMENT" ]; then
  if [ ! -z "$JSON" ]; then
    JSON=${JSON}","
  fi
  JSON=${JSON}$(printf '"ProblemComment":"%s"' "$PROBLEMCOMMENT")
fi
if [ ! -z "$SCREENSHOTLIST1" ] || [ ! -z "$SCREENSHOTLIST2" ] || [ ! -z "$SCREENSHOTLIST3" ]; then
  SCREENSHOTLIST=$(printf '"%s"' "$SCREENSHOTLIST1")
  if [ ! -z "$SCREENSHOTLIST2" ]; then
    if [ ! -z "$SCREENSHOTLIST" ]; then
      SCREENSHOTLIST=${SCREENSHOTLIST}","
    fi
    SCREENSHOTLIST=${SCREENSHOTLIST}$(printf '"%s"' "$SCREENSHOTLIST2")
  fi
  if [ ! -z "$SCREENSHOTLIST3" ]; then
    if [ ! -z "$SCREENSHOTLIST" ]; then
      SCREENSHOTLIST=${SCREENSHOTLIST}","
    fi
    SCREENSHOTLIST=${SCREENSHOTLIST}$(printf '"%s"' "$SCREENSHOTLIST3")
  fi
  if [ ! -z "$JSON" ]; then
    JSON=${JSON}","
  fi
  JSON=${JSON}$(printf '"ScreenshotList":[%s]' "$SCREENSHOTLIST")
fi
if [ ! -z "$LOGFILESLIST1" ] || [ ! -z "$LOGFILESLIST2" ] || [ ! -z "$LOGFILESLIST3" ]; then
  LOGFILESLIST=$(printf '"%s"' "$LOGFILESLIST1")
  if [ ! -z "$LOGFILESLIST2" ]; then
    if [ ! -z "$LOGFILESLIST" ]; then
      LOGFILESLIST=${LOGFILESLIST}","
    fi
    LOGFILESLIST=${LOGFILESLIST}$(printf '"%s"' "$LOGFILESLIST2")
  fi
  if [ ! -z "$LOGFILESLIST3" ]; then
    if [ ! -z "$LOGFILESLIST" ]; then
      LOGFILESLIST=${LOGFILESLIST}","
    fi
    LOGFILESLIST=${LOGFILESLIST}$(printf '"%s"' "$LOGFILESLIST3")
  fi
  if [ ! -z "$JSON" ]; then
    JSON=${JSON}","
  fi
  JSON=${JSON}$(printf '"LogFilesList":[%s]' "$LOGFILESLIST")
fi
if [ ! -z "$EMAIL" ]; then
  if [ ! -z "$JSON" ]; then
    JSON=${JSON}","
  fi
  JSON=${JSON}$(printf '"Email":"%s"' "$EMAIL")
fi
if [ ! -z "$HOMECOUNTRY" ]; then
  if [ ! -z "$JSON" ]; then
    JSON=${JSON}","
  fi
  JSON=${JSON}$(printf '"HomeCountry":"%s"' "$HOMECOUNTRY")
fi
if [ ! -z "$PHONE" ]; then
  if [ ! -z "$JSON" ]; then
    JSON=${JSON}","
  fi
  JSON=${JSON}$(printf '"Phone":"%s"' "$PHONE")
fi
if [ ! -z "$INCIDENTNUMBER" ]; then
  if [ ! -z "$JSON" ]; then
    JSON=${JSON}","
  fi
  JSON=${JSON}$(printf '"IncidentNumber":"%s"' "$INCIDENTNUMBER")
fi
if [ ! -z "$MINIMISE" ]; then
  if [ ! -z "$JSON" ]; then
    JSON=${JSON}","
  fi
  JSON=${JSON}$(printf '"Minimise":"%s"' "$MINIMISE")
fi

JSONFILE="{"${JSON}"}"
logger JSONFILE = ${JSONFILE}
echo ${JSONFILE} >> $fileSignal

# wait until the signal file has been deleted (export ready)
while [ -e $fileSignal ];
do
   sleep 1
done

# now move and rename the exported file
mv $fileDownload ../Report.nif

#echo -e "Content-Type: application/octet-stream Content-Disposition: attachment; filename=\"Report.nif\"
echo Content-Type: application/octet-stream; name="Report.nif"
echo Content-Disposition: filename="Report.nif"
echo
cat ../Report.nif
