#!/bin/sh
set -u

source /lib/functions/navico_env.sh

navico_env_init

check_port_or_exit() {
    # To prevent multiple actions of event
    if [ -z "${port:-}" ]; then
        exit 0
    fi
}

case "$ACTION" in
remove)
    case "$FAMILYID" in
    Hatchetfish)
        port="$(echo "$DEVPATH" | sed -ne 's/.*usb\([0-9]*\)\/[12]-1$/\1/p')"
        check_port_or_exit
        usb-monitor reset $port
        ;;
    esac
    ;;
change)
    port="$(echo "$DEVPATH" | sed -ne 's/.*usb\([0-9]*\)\/[12]-1\/.*/\1/p')"
    check_port_or_exit
    usb-monitor check $port
    ;;
esac
