#!/bin/sh
# Install compatibility shims for pkgtools running on busybox.

# This file belongs in the regular userspace (rootfs).
# The initramfs pkgtool commands may attempt to use it to find
# more up-to-date component wrappers.
# If you want the ramdisk to use its internal copy instead,
# set the following commented text string to 'false'
#    ALLOW_INITRAMFS_SOURCE=true

if [ "${PKGTOOLPATH+p}" != "p" ]; then
    PKGTOOLPATH=""
    PKGTOOLLIB="${PKGTOOLROOT}${PKGTOOLLIB:-/lib/pkgtools/compat}"

    ## These are likely to be present in a BusyBox installation.
    # Tool wrappers.
    for TOOL in gzip bzip2 lzma xz ls rm ; do
	if ${TOOL} --version </dev/null 2>&1 | grep -q "^BusyBox" ; then
	    PKGTOOLPATH="${PKGTOOLLIB}/bb/${TOOL}:${PKGTOOLPATH}"
	fi
    done
    unset TOOL

    # Shim for BusyBox tar
    if ! tar-1.13 --version >/dev/null 2>/dev/null ; then
	PKGTOOLPATH="${PKGTOOLLIB}/bb/tar-1.13:${PKGTOOLPATH}"
    fi

    ## These are not part of BusyBox, and won't be present unless
    ## the GNU alternative parent package is installed.
    # Reimplementation of 'paste' in Bourne shell.
    if ! paste --version >/dev/null 2>/dev/null ; then
	PKGTOOLPATH="${PKGTOOLLIB}/paste:${PKGTOOLPATH}"
    fi
    # Reimplementation of 'rev' in sed.
    if ! echo | rev >/dev/null 2>/dev/null ; then
	PKGTOOLPATH="${PKGTOOLLIB}/rev:${PKGTOOLPATH}"
    fi

    # A /tmp is needed for makepkg to operate.
    if ! mkdir -m 1777 -p /tmp ; then
	echo "You need a /tmp to operate makepkg, please create this as root."
    fi

    unset PKGTOOLLIB
    PATH=$PKGTOOLPATH:$PATH
fi
