gpio_idx() {
    local gpio_name=$1
    grep "^${gpio_name}\s" /proc/navico_platform/gpio | cut -f2
}

export_gpio() {
    local gpio=$1 v_val=${2:-} d_val

    if [ ! -e /sys/class/gpio/gpio${gpio} ]; then
        echo $gpio > /sys/class/gpio/export
    fi

    # Set the GPIO state if specified
    if [ -n "$v_val" ]; then
        case $v_val in
            0|low|out) v_val=0; d_val=low ;;
            1|hi|high) v_val=1; d_val=high ;;
            in)        v_val=0; d_val=in ;;
            *)         echo "$0: Invalid gpio value $v_val." >&2; return 1 ;;
        esac

        if [ -w /sys/class/gpio/gpio${gpio}/direction ]; then
            # Set GPIO output value using the 'direction' file
            # This sets the GPIO value and direction at once
            echo $d_val >/sys/class/gpio/gpio${gpio}/direction
        else
            # GPIO is exposed as output-only by kernel, no direction file
            echo $v_val >/sys/class/gpio/gpio${gpio}/value
        fi
    fi
}

gpio_get_value() {
    cat "/sys/class/gpio/gpio${1}/value"
}

gpio_set_value() {
    printf "%s" "$2" > "/sys/class/gpio/gpio${1}/value"
}

gpio_set_direction_input() {
    printf "in" > "/sys/class/gpio/gpio${1}/direction"
}

gpio_set_direction_output() {
    local direction=out

    if [ ${#} -ge 2 ]; then
        case ${2} in
        0)
            direction=low
            ;;
        1)
            direction=high
            ;;
        *)
            printf "%s: Invalid direction value %s\n" "$0" "$2"
            return 1
            ;;
        esac
    fi

    printf "%s" "$direction" > "/sys/class/gpio/gpio${1}/direction"
}
