#!/bin/sh
#
# /etc/rc.d/rc.R:  System shutdown/reboot script.
#

source /lib/functions/navico_env.sh
navico_env_init

# Wait for coredump to complete
if [ -x /etc/rc.d/rc.navico-coredump ]; then
   /etc/rc.d/rc.navico-coredump stop
fi

if [ "${FAMILYID}" = "Radar" ]; then
    if [ -x /etc/rc.d/rc.radar.app ]; then
        /etc/rc.d/rc.radar.app stop
    fi
else
    # NOSApp needs to let go of mounted resources
    if [ -x /etc/rc.d/rc.app ]; then
        /etc/rc.d/rc.app stop
    fi
fi

### Network services
if [ -x /etc/rc.d/rc.mediadaemon ]; then
   /etc/rc.d/rc.mediadaemon stop
fi

# NFS
if [ -x /etc/rc.d/rc.nfsd ]; then
   /etc/rc.d/rc.nfsd stop
fi
if [ -x /etc/rc.d/rc.rpc ]; then
   /etc/rc.d/rc.rpc stop
fi

# stop sshd
if [ -x /etc/rc.d/rc.sshd ]; then
  /etc/rc.d/rc.sshd stop
fi


### Local bookkeeping
# Shut down time services
if [ -x /etc/rc.d/rc.time ]; then
  /etc/rc.d/rc.time stop
fi


### Core services
# stop udev
if [ -x /etc/rc.d/rc.udev ]; then
  /etc/rc.d/rc.udev stop
fi


### Unmount all
sync
sync
# We only need to umount media-based file systems except the root fs.
for MOUNTPOINT in $(grep " ubifs \| jffs2 \| ext2 \| vfat " /proc/mounts | \
   grep -v ' / ' | \
   cut -d ' ' -f 2 | \
   sort -r);
do
   /bin/umount -rlf "${MOUNTPOINT}"
done

# If any exist, detach as many UBI MTDs as possible
# We expect a UBI MTD containing a rootfs volume to fail detachment.
stat /sys/class/ubi/ubi*/mtd_num >/dev/null 2>&1 || \
   for MTD in /sys/class/ubi/ubi*/mtd_num; do
      ubidetach /dev/ubi_ctrl -m "$(cat ${MTD})"
   done

# Remount the rootfs as readonly.
mount -o remount,ro /
