#!/bin/sh
# shell-prompt-busybox.sh:
#  Create a familiar "user@host:path$ " prompt
#  when using busybox's sh as a log-in shell.

if [ -z "${BASH_VERSION}" \
   -a -z "${KSH_VERSION}" \
   -a -z "${ZSH_VERSION}" ];
then
   # Congrats!  You've probably using some kind of Almquist shell variant.

   cd () {
      local RET
      local HOST
      local PWD
      local PROMPT

      command cd "$@"
      RET=$?

      HOST="${HOSTNAME:-"$(/bin/hostname 2>/dev/null || true)"}"
      if [ "$(pwd)" = "${HOME}" ]; then
         PWD='~'
      else
         PWD="$(pwd)"
      fi
      PROMPT="$(test "$(id -u)" = "0" && echo "#")"
      PS1="${LOGNAME:-"no name"}@${HOST:-"(none)"}:${PWD:-"?"}${PROMPT:-"$"} "
      return ${RET}
   }
   cd .
fi
