find_ubi_volume_num_from_name() {
    # Returns the named UBI-volume device in format ubiX_Y (eg ubi0_1)
    # Name can optionally include UBI device, eg "ubi0:root" (rather than just "root")
    local dev=${1%%:*} name=${1#*:}

    [ "$dev" = "$name" ] && dev="ubi0"

    local syspath
    for syspath in /sys/class/ubi/${dev}_?; do
        if [ "$(cat ${syspath}/name 2>/dev/null)" = "$name" ]; then
            echo "${syspath##*/}"
            return 0
        fi
    done

    return 1
}


init_user_partitions() {
    # Init user (home, noslog) partitions if they are not created or corrupt.
    # Factory reset request deletes and recreates the user related partitions.
    local factory_reset=$1
    local nos_home=/home/nos
    local noslog_path=${nos_home}/log
    local home_ubidev=
    local noslog_ubidev=

    # home/noslog partition creation.
    if home_ubidev=$(find_ubi_volume_num_from_name home) &&
        [ "$factory_reset_req" = true -o ! -e "/home/.fscreated" ]; then
        home_ubidev=/dev/$home_ubidev

        # noslog partition detection.
        if noslog_ubidev=$(find_ubi_volume_num_from_name noslog); then
            noslog_ubidev=/dev/$noslog_ubidev
        fi

        if [ -n "${noslog_ubidev:-}" ] && mountpoint -q "$noslog_path"; then
            umount "$noslog_path"
        fi

        if mountpoint -q /home; then
            umount /home
        fi

        ubiupdatevol "$home_ubidev" -t
        mount /home
        mkdir -p  "$nos_home"

        if [ -n "${noslog_ubidev:-}" ]; then
            mkdir -p "$noslog_path"
            ubiupdatevol -t "$noslog_ubidev"
            mount "$noslog_path"
        fi

        # Add flag so we remember fs is generated. Also used by some scripts to force a factory reset.
        touch /home/.fscreated
        chown -R nos:$(id -g nos) "$nos_home"
        sync
    fi
}
