SYSCFGDIR=/run/sysconfig
SYSCFGDIR_PERSISTENT=/etc/NOS/sysconfig

sysconfig_enabled() {
  [ -e $SYSCFGDIR/$1 ]
}

sysconfig_metadata() {
  local flag=$1 key=${2:-}

  if [ -n "$key" ]; then
    # Strip trailing comment and whitespace after key-value.
    sed -ne '/^'"$key"'=/{ s/^[^=]*=//; s/#.*$//; s/[ \t]*$//; p; }' < "$SYSCFGDIR_PERSISTENT/$flag"
  else
    cat "$SYSCFGDIR_PERSISTENT/$flag"
  fi
}

# Initialise the system configuration flags (requires /etc/NOS to be mounted)
sysconfig_init() {
  local flags=""
  local f=$(find /etc/NOS/sysconfig -maxdepth 1 -type f ! \( -name debug_mode -o -name serialcon \) 2>/dev/null || true)

  # /run/shm/debug is exchanged between CPU's on Hatchetfish
  if [ -e /run/shm/debug ] || grep -siq '\bdebug\b' /proc/cmdline; then
    f="$f debug_mode"
  fi

  if grep -siq "\bconsole=[^ ]\+\b" /proc/cmdline; then
    f="$f serialcon"
  fi

  if [ -n "$f" ]; then
    for f in $f; do
      f="${f##*/}" # basename

      case "$f" in
	burnin_anymac|\
	eeti_fwupd_disable|\
        eeti_verbose_debug|\
	crash_halt|\
	crashlog|\
	debuglog|\
	ftp_root|\
	gpu_debug|\
	log_persist|\
	log_remote|\
	log_toconsole|\
	navico_lan|\
	netdev_config|\
	serialcon|\
	static_ip|\
	telnet)         ;;
	# Combination flags
	debug_mode)     f="$f telnet crash_halt log_toconsole" ;;
	sqa_mode)       f="$f static_ip telnet burnin_anymac crash_halt crashlog debuglog log_remote " ;;
	dev_mode)       f="$f static_ip telnet burnin_anymac crash_halt crashlog debuglog ftp_root" ;;
	dev_rtr_mode)   f="$f static_ip telnet burnin_anymac crash_halt crashlog debuglog log_remote navico_lan ftp_root" ;;
	pvlab_mode)     f="$f static_ip telnet log_remote" ;;
	# Unknown flags
	*)              printf 'Ignoring undefined sysconfig flag "%s"\n' "$f" >&2
	                continue ;;
      esac

      flags="$flags $f"
    done
  fi

  # Legacy crashlog support (mimic the old behaviour)
  # Must be checked after combination flags are expanded above
  if grep -siq "^CreateCrashLog=true" /etc/NOS/Config.ini && ! printf "%s" "$flags"|grep -q "\bcrashlog\b"; then
    flags="$flags crashlog debuglog log_toconsole"
  fi

  if [ -n "$flags" ]; then
    flags=$(printf "%s" "$flags" | tr ' ' '\n' | sort -u | tr '\n' ' ' | sed 's_^\s\+__; s_\s\+$__')

    if (
      set -e
      mkdir -p $SYSCFGDIR
      cd $SYSCFGDIR
      touch $flags
    );
    then
      printf "sysconfig=(%s)\n" "$flags"
    else
      printf "FAILED to set sysconfig (%s)\n" "$flags"
    fi >&2
  fi
}

