navico_env_init() {
    if [ "${FAMILYID+f}${SUBFAMILYID+s}${PROCESSOR_FAMILY+p}${CODENAME+c}${HW_REVISION+h}${DISPSIZE+d}${FRAMEBUFFER+b}" != "fspchdb" ]; then
        FAMILYID=$(cut -f2 /proc/navico_platform/family_id || echo unknown)
        SUBFAMILYID=$(cut -f1 /proc/navico_platform/sub_family_id || echo unknown)
        PROCESSOR_FAMILY=$(cut -f2 /proc/navico_platform/cpuinfo || echo unknown)
        HW_REVISION=$(cut -f1 /proc/navico_platform/mainboard_hw_rev || echo unknown)
        DISPSIZE=$(cut -f 2 /proc/navico_platform/disp_size || echo unknown)

        if [ -e /dev/fb_primary ]; then
            FRAMEBUFFER=$(readlink -f /dev/fb_primary)
        else
            FRAMEBUFFER=/dev/fb0
        fi

        # Note:
        #   You should *almost* always use FAMILYID, not CODENAME.
        #   FAMILYID identifies the hardware, CODENAME the product.
        #   CODENAME is always lowercase and defaults to FAMILYID if not specified.
        CODENAME=$( printf '%s\n' "$FAMILYID" | awk '
            {
                if (FILENAME == "-") {
                    codename = $0;
                } else if (match($0, "navico_sku\.codename=[^ ]+")) {
                    codename = substr($0,RSTART+20,RLENGTH-20);
                }
            }
            END { printf "%s\n", tolower(codename); }
        ' - /proc/cmdline)

        if [ "$CODENAME" = 'forefraz' ]; then
            if [ "$SUBFAMILYID" = 2 ]; then
                CODENAME=gilligan
            elif [ "$(cut -f2 /proc/navico_platform/sonar_present)" = "true" ]; then
                CODENAME=foreman
            else
                CODENAME=frazier
            fi
        fi

        if [ "$CODENAME" = 'sylvester' ]; then
            case "$SUBFAMILYID" in
            0) SIZE=7;;
            1) SIZE=5;;
            2) SIZE=4;;
            3) SIZE=4g;;
            4) SIZE=9;;
            esac

            if [ $(( ${HW_REVISION} & 4 )) = 4 ]; then
               CODENAME=bulldog
            fi

            CODENAME=${CODENAME}${SIZE}
            if [ "$CODENAME" = "sylvester7" ]; then
               CODENAME=sylvester
            fi
        fi

        if [ "$CODENAME" = 'kiwi' ]; then
           if [ $(( ${HW_REVISION} & 8 )) = 8 ]; then
             CODENAME=houdini
           fi
        fi

        if [ "$CODENAME" = "repower" ]; then
            case "$SUBFAMILYID" in
            1)
                case "$HW_REVISION" in
                8) CODENAME=vikingsimradinstrument ;;
                4) CODENAME=vikingsimradpilot ;;
                esac
                ;;
            2) CODENAME=chunkypro ;;
            3) CODENAME=pukeko ;;
            esac
        fi

        export FAMILYID SUBFAMILYID PROCESSOR_FAMILY CODENAME HW_REVISION DISPSIZE FRAMEBUFFER
    fi

    readonly FAMILYID SUBFAMILYID PROCESSOR_FAMILY CODENAME HW_REVISION DISPSIZE FRAMEBUFFER
}
