get_macaddr() {
    cat /etc/NOS/MAC
}

init_macaddr() {
    local mac_addr
    local mac_file=/etc/NOS/MAC

    if ! grep -s "^..:..:..:..:..:..$" "$mac_file"; then
        # Generate a new fake MAC address
        RANDOM="$(cat /proc/sys/kernel/random/boot_id)"  # Seed the generator with the boot ID
        mac_addr="00:80:0f"  # Standard Microsystems Corp. (SMSC) address block
        mac_addr="${mac_addr}$(
          printf ':%02x' $((${RANDOM}%256))
          printf ':%02x' $((${RANDOM}%256))
          printf ':%02x' $((${RANDOM}%256))
        )"

        local partition=/etc/NOS
        local remount_ro=true

        if [ "$(grep "$partition" /proc/mounts | cut -f 4 -d ' ')" != "ro" ]; then
            remount_ro=false
        fi

        # Record the address.
        mount -o remount,rw "$partition"
        printf "%s\n" "$mac_addr" > "$mac_file"
        sync
        if [ "$remount_ro" = "true" ]; then
            mount -o remount,ro "$partition"
        fi
    fi
}
