have_emmc() {
  # Tolerate different driver names:
  #   2198000.usdhc on imx6 kernel >= 3.10.*
  #   sdhci-esdhc-imx on imx6 kernel version 3.0.35
  #   mxsdhci on mx51
  # Possible values for card/type are: "MMC", "SD", "SDIO", "SDcombo" (3.14.28 kernel).

  for card in \
    /sys/devices/soc0/soc/2100000.aips-bus/2198000.usdhc/mmc_host/mmc*/mmc*:0001 \
    /sys/devices/platform/sdhci-esdhc-imx.2/mmc_host/mmc*/mmc*:0001 \
    /sys/devices/platform/mxsdhci.2/mmc_host/mmc*/mmc*:0001;
  do
    if [ -r "$card/type" ]; then
      case $(cat "$card/type") in
        SD|MMC) return 0 ;;
        *)      return 1 ;;
      esac
    fi
  done

  return 1
}

