codename_to_hostname() {
    local host

    # If hostname is unspecified (or invalid) assemble a default
    case $CODENAME in
        cougar)               host=HDS ;;
        hatchetfish)          host=NSO2 ;;
        muriwai)              host=Z2BB ;;
        radar)                host=Radar ;;
        cassius)              host=NSS2 ;;
        clinton)              host=HDS3 ;;
        dubya)                host=HDSC ;;
        norris)               host=NSS3 ;;
        tortuga)              host=ZEUS3 ;;
        copperfield)          host=VV703 ;;
        sonarhub)             host=SonarHub ;;
        luigi)                host=SonarHub3D ;;
        newton)               host=S3DHD ;;
        yoshi)                host=S5100 ;;
        lubeck)               host=ZEUS2W ;;
        penn|teller)          host=VV2 ;;
        floydbandg|vulcan*)   host=Vulcan ;; # Will match first before the next line
        floyd*)               host=GO ;;
        thor)                 host=E5000 ;;
        bobo|porky)           host=EliteTi ;;
        foreman)
            case "$SUBFAMILYID" in
            0)                host=S2009 ;;
            1)                host=S2016 ;;
            esac
            ;;
        dynamo)               host=VV903 ;;
        frazier)
            case "$SUBFAMILYID" in
            0)                host=R2009 ;;
            1)                host=R3016 ;;
            esac
            ;;
        lisa)                 host=R5000 ;;
        gilligan)             host=S3009 ;;
        *)  host=${CODENAME:-unknown}
            printf '%s: Unknown CODENAME "%s".\n' "$0" "$CODENAME" 1>&2
            ;;
    esac

    printf "%s\n" "$host"
}

codename_to_model() {
    local model

    case "${CODENAME}-${SUBFAMILYID}" in
        cougar-0)       model="HDS-7T" ;;
        cougar-1)       model="HDS-9T" ;;
        cougar-2)       model="HDS-12T" ;;
        hatchetfish-*)  model="NSO evo2" ;;
        muriwai-*)      model="Zeus2 Black Box" ;;
        cassius-0)      model="NSS7 evo2" ;;
        cassius-1)      model="NSS9 evo2" ;;
        cassius-2)      model="NSS12 evo2" ;;
        cassius-3)      model="NSS16 evo2" ;;
        norris-0)       model="NSS7 evo3" ;;
        norris-1)       model="NSS9 evo3" ;;
        norris-2)       model="NSS12 evo3" ;;
        norris-3)       model="NSS16 evo3" ;;
        lubeck-0)       model="Zeus2 W7" ;;
        lubeck-1)       model="Zeus2 W9" ;;
        lubeck-2)       model="Zeus2 W12" ;;
        lubeck-3)       model="Zeus2 W16" ;;
        tortuga-*)      model="Zeus3" ;;
        clinton-0)      model="HDS3-5" ;;
        clinton-1)      model="HDS3-7" ;;
        clinton-2)      model="HDS3-9" ;;
        clinton-3)      model="HDS3-12" ;;
        dubya-0)        model="HDSC-7" ;;
        dubya-1)        model="HDSC-9" ;;
        dubya-2)        model="HDSC-12" ;;
        dubya-3)        model="HDSC-16" ;;
        floyd-0)        model="GO7" ;;
        floydfs-0)      model="GO7 XSE" ;;
        floydjr-0)      model="GO5 XSE" ;;
        floydsr-0)      model="GO9 XSE" ;;
        floydmv-0)      model="GO12 XSE" ;;
        floydrm-0)      model="GO7 XSR" ;;
        floydbandg-0)   model="Vulcan 7" ;;
        vulcanfs-0)     model="Vulcan 7 FS" ;;
        vulcanjr-0)     model="Vulcan 5 FS" ;;
        vulcansr-0)     model="Vulcan 9" ;;
        vulcanmv-0)     model="Vulcan 12" ;;
        vulcanrm-0)     model="Vulcan 7R" ;;
        teller-*)       model="VV502" ;;
        thor-*)         model="E5000" ;;
        bobo-0)         model="Elite7-Ti" ;;
        bobo-1)         model="Elite9-Ti" ;;
        bobo-2)         model="Elite12-Ti" ;;
        porky-0)        model="Elite5-Ti" ;;
        foreman-0)      model="S2009" ;;
        foreman-1)      model="S2016" ;;
        frazier-0)      model="R2009" ;;
        frazier-1)      model="R3016" ;;
        penn-*)         model="VV702" ;;
        copperfield-0)  model="VV703" ;;
        lisa-*)         model="R5000" ;;
        dynamo-*)       model="VV903" ;;
        gilligan-2)      model="S3009" ;;
        *)              model="Unknown" ;;
    esac

    printf "%s\n" "$model"
}
